clear all
set more off, permanently
*
*  Set root directory here
*
global root "/Users//`=c(username)'/Box/Metcalf Files/BPEA Carbon Tax/BPEA Final Version/Data for Website Figures and Tables/"

log using BPEA.log, replace
*
*    BPEA Metcalf Tables and Figures Construction  [10/14/19
*        This file creates datasets to construct Tables 2 - 6 in paper 
*
do DataConstruct

******************************* TABLES *****************************************************

******************** Table 1 taken directly from source ************************

***************************** Create Table2-5 **********************************
clear all
set matsize 500

global tables = "$root/tables"
cd "$root" 

use data/CanData 

gen woodBC = wood07*(ID=="BC") 
gen trAB = year*(ID=="AB") 
gen trBC = year*(ID=="BC") 
gen trMB = year*(ID=="MB")
gen trNB = year*(ID=="NB") 
gen trNL = year*(ID=="NL") 
gen trNS = year*(ID=="NS") 
gen trNT = year*(ID=="NT") 
gen trNU = year*(ID=="NU") 
gen trON = year*(ID=="ON") 
gen trPE = year*(ID=="PE") 
gen trQC = year*(ID=="QC") 
gen trSK = year*(ID=="SK") 
gen trYT = year*(ID=="YT") 
gen trNTN = year*(ID=="NTN") 

*Generating GDP and Canadian GDP related variables
gen lngdp = ln(gdp)
gen gdp_pop = gdp / pop
gen lngdppc = ln(gdp_pop)

gen lngdp_Can = ln(gdp_Can)
gen gdppc_Can = gdp_Can / pop_Can
gen lngdppc_Can = ln(gdppc_Can)

*generating log of population
gen lnpop = ln(pop)

gen lnghg = ln(GHG)
gen lnco2 = ln(co2)

gen co2_gdp = co2/gdp
gen ln_co2_gdp = ln(co2_gdp)

*generate post carbon tax start as the beginning of 2008
gen postCT = (year >= 2008)
gen BCCT = (year >= 2008 & ID == "BC")

*generate post carbon tax start as the beginning of 2009
gen postCT2 = (year >= 2009)
gen BCCT2 = (year >= 2009 & ID == "BC")

*generate "treatment group" BC
gen BC = ID =="BC"

*generate carbon tax intensity as annual averages
gen BCCTint_av = 5 if (year == 2008 & ID == "BC")
replace BCCTint_av = 12.5 if (year == 2009 & ID == "BC")
replace BCCTint_av = 17.5 if (year == 2010 & ID == "BC")
replace BCCTint_av = 22.5 if (year == 2011 & ID == "BC")
replace BCCTint_av = 27.5 if (year == 2012 & ID == "BC")
replace BCCTint_av = 30 if (year >= 2013 & ID == "BC")
replace BCCTint_av = 0 if missing(BCCTint_av)

*generate carbon tax intensity as actual yearly values
gen BCCTint = 10 if (year == 2008 & ID == "BC")
replace BCCTint = 15 if (year == 2009 & ID == "BC")
replace BCCTint = 20 if (year == 2010 & ID == "BC")
replace BCCTint = 25 if (year == 2011 & ID == "BC")
replace BCCTint = 30 if (year >= 2012 & ID == "BC")
replace BCCTint = 0 if missing(BCCTint)

*generate carbon tax annual value for Alberta, Quebec and BC
gen CT_rate = 10 if (year == 2008 & ID == "BC")
replace CT_rate = 15 if (year == 2009 & ID == "BC")
replace CT_rate = 20 if (year == 2010 & ID == "BC")
replace CT_rate = 25 if (year == 2011 & ID == "BC")
replace CT_rate = 30 if (year >= 2012 & ID == "BC")

replace CT_rate = 3.5 if (year >= 2007 & year < 2013 & ID == "QC")
replace CT_rate = 12.36 if (year == 2013 & ID == "QC")
replace CT_rate = 13.15 if (year == 2014 & ID == "QC")
replace CT_rate = 16.58 if (year == 2015 & ID == "QC")
replace CT_rate = 17.93 if (year == 2016 & ID == "QC")
 
replace CT_rate = 15 if (year >= 2007 & ID == "AB")
 
replace CT_rate = 0 if missing(CT_rate)

*generating province x year time trends
global trp "trAB - trNS trON - trSK" 

*generating year dummies
tab year, gen(yr) 

cd "$tables"


**************************Table 2 - CO2 emissions D-n-D **************************************

areg lnco2 BCCT lngdp lnpop pexport2                                yr10-yr35 if year >= 1990, absorb(ID) cluster(province) 
outreg2 using table2.doc, replace dec(3) title(Table 2: Carbon Dioxide Emission Regressions: BC Difference-in-Difference) ctitle(Model 1) sortvar(BCCT lngdp lnpop pexport2) addtext(Provinces and Territories, All, Years, 1990-2016) drop(yr10-yr35)

areg lnco2 BCCT lngdp lnpop pexport2                                yr10-yr35 if year >= 1990 & ID != "AB" & ID != "ON" & ID != "QC", absorb(ID) cluster(province) 
outreg2 using table2.doc, append dec(3) title(Table 2: Carbon Dioxide Emission Regressions: BC Difference-in-Difference) ctitle(Model 2) sortvar(BCCT lngdp lnpop pexport2) addtext(Provinces and Territories, Exclude AL ON QC, Years, 1990-2016) drop(yr10-yr35)

areg lnco2 BCCT lngdp lnpop pexport2                                yr10-yr35 if year >= 1995 & ID != "AB" & ID != "ON" & ID != "QC", absorb(ID) cluster(province) 
outreg2 using table2.doc, append dec(3) title(Table 2: Carbon Dioxide Emission Regressions: BC Difference-in-Difference) ctitle(Model 3) sortvar(BCCT lngdp lnpop pexport2) addtext(Provinces and Territories, Exclude AL ON QC, Years, 1995-2016) drop(yr10-yr35)

areg ln_co2_gdp BCCT lnpop pexport2                                yr10-yr35 if year >= 1990 & ID != "AB" & ID != "ON" & ID != "QC", absorb(ID) cluster(province) 
outreg2 using table2.doc, append dec(3) title(Table 2: Carbon Dioxide Emission Regressions: BC Difference-in-Difference) ctitle(Model 4) sortvar(BCCT lngdp lnpop pexport2) addtext(Provinces and Territories, Exclude AL ON QC, Years, 1990-2016) drop(yr10-yr35)

areg ln_co2_gdp BCCT lnpop pexport2                                yr10-yr35 if year >= 1995 & ID != "AB" & ID != "ON" & ID != "QC", absorb(ID) cluster(province) 
outreg2 using table2.doc, append dec(3) title(Table 2: Carbon Dioxide Emission Regressions: BC Difference-in-Difference) ctitle(Model 5) sortvar(BCCT lngdp lnpop pexport2) addtext(Provinces and Territories, Exclude AL ON QC, Years, 1995-2016) drop(yr10-yr35)


*************************Table 3 - CO2 emissions Tax Rate*************************************

areg lnco2 CT_rate lngdp lnpop pexport2                                yr10-yr35 if year >= 1990, absorb(ID) cluster(province) 
outreg2 using table3.doc, replace dec(4) title(Table 3: Carbon Dioxide Emission Regressions: BC Difference-in-Difference) ctitle(Model 1) sortvar(CT_rate lngdp lnpop pexport2) addtext(Provinces and Territories, All, Years, 1990-2016) drop(yr10-yr35)

areg lnco2 CT_rate lngdp lnpop pexport2                                yr10-yr35 if year >= 1990 & ID != "ON", absorb(ID) cluster(province) 
outreg2 using table3.doc, append dec(4) title(Table 3: Carbon Dioxide Emission Regressions: BC Difference-in-Difference) ctitle(Model 2) sortvar(CT_rate lngdp lnpop pexport2) addtext(Provinces and Territories, Exclude AL ON QC, Years, 1990-2016) drop(yr10-yr35)

areg lnco2 CT_rate lngdp lnpop pexport2                                yr10-yr35 if year >= 1995 & ID != "ON", absorb(ID) cluster(province) 
outreg2 using table3.doc, append dec(4) title(Table 3: Carbon Dioxide Emission Regressions: BC Difference-in-Difference) ctitle(Model 3) sortvar(CT_rate lngdp lnpop pexport2) addtext(Provinces and Territories, Exclude AL ON QC, Years, 1995-2016) drop(yr10-yr35)

areg ln_co2_gdp CT_rate lnpop pexport2                                yr10-yr35 if year >= 1990 & ID != "ON", absorb(ID) cluster(province) 
outreg2 using table3.doc, append dec(4) title(Table 3: Carbon Dioxide Emission Regressions: BC Difference-in-Difference) ctitle(Model 4) sortvar(CT_rate lngdp lnpop pexport2) addtext(Provinces and Territories, Exclude AL ON QC, Years, 1990-2016) drop(yr10-yr35)

areg ln_co2_gdp CT_rate lnpop pexport2                                yr10-yr35 if year >= 1995 & ID != "ON", absorb(ID) cluster(province) 
outreg2 using table3.doc, append dec(4) title(Table 3: Carbon Dioxide Emission Regressions: BC Difference-in-Difference) ctitle(Model 5) sortvar(CT_rate lngdp lnpop pexport2) addtext(Provinces and Territories, Exclude AL ON QC, Years, 1995-2016) drop(yr10-yr35)


************************Table 4 - GDP D-n-D*************************************************

areg lngdp BCCT lngdp_Can lnpop pexport2                                if year >= 1990, absorb(ID) cluster(province) 
outreg2 using table4.doc, replace dec(4) title(Table 4: GDP Regressions: BC Difference-in-Difference) ctitle(Model 1) sortvar(BCCT lngdp_Can lnpop pexport2) addtext(Provinces and Territories, All, Years, 1990-2016) drop(yr10-yr35)

areg lngdp BCCT lngdp_Can lnpop pexport2 Smanuf Sprof Spublic Sforest 	if year >= 1990 & ID != "NTN" & ID != "YT" & ID != "NT" & ID != "NU", absorb(ID) cluster(province) 
outreg2 using table4.doc, append dec(4) title(Table 4: GDP Regressions: BC Difference-in-Difference) ctitle(Model 2) sortvar(BCCT lngdp_Can lnpop pexport2 Smanuf Sprof Spublic Sforest) addtext(Provinces and Territories, Provinces Only, Years, 1990-2016) drop(yr10-yr35)

areg lngdp BCCT lngdp_Can lnpop pexport2 Smanuf Sprof Spublic Sforest   if year >= 1990 & ID != "AB" & ID != "ON" & ID != "QC" & ID != "NTN" & ID != "YT" & ID != "NT" & ID != "NU", absorb(ID) cluster(province) 
outreg2 using table4.doc, append dec(4) title(Table 4: GDP Regressions: BC Difference-in-Difference) ctitle(Model 3) sortvar(BCCT lngdp_Can lnpop pexport2) addtext(Provinces and Territories, Provinces less AB QC ON, Years, 1990-2016) drop(yr10-yr35)

areg lngdp BCCT lngdp_Can lnpop pexport2 Smanuf Sprof Spublic Sforest   if year >= 1995 & ID != "AB" & ID != "ON" & ID != "QC" & ID != "NTN" & ID != "YT" & ID != "NT" & ID != "NU", absorb(ID) cluster(province) 
outreg2 using table4.doc, append dec(4) title(Table 4: GDP Regressions: BC Difference-in-Difference) ctitle(Model 4) sortvar(BCCT lngdp_Can lnpop pexport2) addtext(Provinces and Territories, Provinces less AB QC ON, Years, 1995-2016) drop(yr10-yr35)


**************************Table 5 - GDP Tax Rate***********************************************

areg lngdp CT_rate lngdp_Can lnpop pexport2                               if year >= 1990, absorb(ID) cluster(province) 
outreg2 using table5.doc, replace dec(4) title(Table 5: GDP Regressions: Tax Rate Regressions) ctitle(Model 1) sortvar(CT_rate BCCT lngdp_Can lnpop pexport2) addtext(Provinces and Territories, All, Years, 1990-2016) drop(yr10-yr35)

areg lngdp CT_rate lngdp_Can lnpop pexport2 Smanuf Sprof Spublic Sforest  if year >= 1990 & ID != "NTN" & ID != "YT" & ID != "NT" & ID != "NU", absorb(ID) cluster(province) 
outreg2 using table5.doc, append dec(4) title(Table 5: GDP Regressions: Tax Rate Regressions) ctitle(Model 2) sortvar(CT_rate BCCT lngdp_Can lnpop pexport2 Smanuf Sprof Spublic Sforest) addtext(Provinces and Territories, Provinces Only, Years, 1990-2016) drop(yr10-yr35)

areg lngdp CT_rate lngdp_Can lnpop pexport2 Smanuf Sprof Spublic Sforest  if year >= 1990 & ID != "ON" & ID != "NTN" & ID != "YT" & ID != "NT" & ID != "NU", absorb(ID) cluster(province) 
outreg2 using table5.doc, append dec(4) title(Table 5: GDP Regressions: Tax Rate Regressions) ctitle(Model 3) sortvar(CT_rate BCCT lngdp_Can lnpop pexport2) addtext(Provinces and Territories, Provinces less ON, Years, 1990-2016) drop(yr10-yr35)

areg lngdp CT_rate lngdp_Can lnpop pexport2 Smanuf Sprof Spublic Sforest  if year >= 1995 & ID != "ON" & ID != "NTN" & ID != "YT" & ID != "NT" & ID != "NU", absorb(ID) cluster(province) 
outreg2 using table5.doc, append dec(4) title(Table 5: GDP Regressions: Tax Rate Regressions) ctitle(Model 4) sortvar(CT_rate BCCT lngdp_Can lnpop pexport2) addtext(Provinces and Territories, Provinces less ON, Years, 1995-2016) drop(yr10-yr35)

********************************** Table 6 *************************************

clear
cd "$root"
do EUDataConstruct

* merge gdpdata with ctax
use "data/gdpdata", clear
merge 1:1 ID year using "data/ctax"
drop _merge
drop if inlist(ID,"DEW","EA19","EU28","OECDE")
order country ID year

sort ID year

* create ctax related variables
gen rate_ = .
replace rate_ = rate if year == 2019
by ID: egen rate19 = max(rate_)
replace rate19 = 0 if rate19 == .
drop rate_
label var rate19 "carbon tax on 4/1/2019 (nominal)"
*
replace ctax = 0 if ctax == .
by ID: egen treat1 = max(ctax)
label var treat1 "carbon tax in any year"
*
gen share_=.
replace share_ = share if year == 2019
by ID: egen share19 = max(share_)
replace share19 = 0 if share19 == .
drop share_
label var share19 "share of jurisdiction's GHG emissions covered by tax in 2019"

* create a dummy variable for Europe ETS participants
gen EU = 0
label var EU "member of EU ETS"
replace EU = 1 if  ID=="AUT" | ID=="BEL" | ID=="BGR" | ID=="CYP" | ID=="CZE" | ID=="DEU" | ID=="DNK" | ID=="ESP" | ///
     ID=="EST" | ID=="FIN" | ID=="FRA" | ID=="GBR" | ID=="GRC" | ID=="HRV" | ID=="HUN" | ID=="IRL" | ID=="ISL" | ///
     ID=="ITA" | ID=="LTU" | ID=="LUX" | ID=="LVA" | ID=="MLT" | ID=="NLD" | ID=="NOR" | ID=="POL" | ID=="PRT" | ///
     ID=="ROU" | ID=="SVK" | ID=="SVN" | ID=="SWE"  
gen EU2 = EU
label var EU2 "EU plus Switzerland"
replace EU2 = 1 if ID=="CHE"

* create OECD-wide GDP
gen gdpRtmp = .
 replace gdpRtmp = gdpR if ID=="OECD"
egen gdpR_oecd = mean(gdpRtmp), by(year)
gen gdppcRtmp = .
 replace gdppcRtmp = gdppcR if ID=="OECD"
egen gdppcR_oecd = mean(gdppcRtmp), by(year)
drop if ID=="OECD"
drop gdpRtmp gdppcRtmp
egen cnum = group(ID)
*
*  focus on EU-ETS countries after 1984
*
*    also - drop 2018 data as incomplete GDP data
*
*
*  set panel
*
xtset cnum year
gen ctax_rate19 = ctax*rate19
gen ctax_share19 = ctax*share19
gen lpop = ln(pop)
*
gen lrgdp = ln(gdpR)
 gen dlrgdp = 100*(lrgdp-L.lrgdp)
gen lrgdppc = ln(gdppcR)
 gen dlrgdppc = 100*(lrgdppc-L.lrgdppc)
* 
gen lrgdp_oecd = ln(gdpR_oecd)
 gen dlrgdp_oecd = 100*(lrgdp-L.lrgdp_oecd)
gen lrgdppc_oecd = ln(gdppcR_oecd)
 gen dlrgdppc_oecd = 100*(lrgdppc_oecd-L.lrgdppc_oecd)
keep if EU2
keep if year > 1984
drop if year == 2018
 
tab year, gen(ydum)
tab ID
*
* --- Levels specifications (parallel shift effect) ---xtreg lrgdp ctax lrgdp_oecd, fe vce(cluster cnum)
*
xtreg lrgdp ctax  lrgdp_oecd, fe vce(cluster cnum)
 outreg2 using "tables/table6.doc" ,  word sortvar(ctax ctax_rate19 ctax_share19) replace  ///
	addtext(Country FE, YES, Year FE, NO)
*
xtreg lrgdp ctax ctax_share19  lrgdp_oecd, fe vce(cluster cnum)
 outreg2 using "tables/table6.doc" ,  word sortvar(ctax ctax_rate19 ctax_share19) ///
    addtext(Country FE, YES, Year FE, NO)
lincom ctax + .3*ctax_share19      /*  50th percentile   */
*
xtreg lrgdp ctax ctax_share19  ydum*, fe vce(cluster cnum)
 outreg2 using "tables/table6.doc" ,  word sortvar(ctax ctax_rate19 ctax_share19) drop(ydum* o.ydum*) ///
    addtext(Country FE, YES, Year FE, YES)
lincom ctax + .3*ctax_share19      /*  50th percentile   */
*
* --- Levels specifications (parallel shift effect) ---xtreg lrgdppc ctax lrgdppc_oecd, fe vce(cluster cnum)
*
xtreg lrgdppc ctax lrgdppc_oecd, fe vce(cluster cnum)
 outreg2 using "tables/table6.doc" ,  word sortvar(ctax ctax_rate19 ctax_share19)   ///
	addtext(Country FE, YES, Year FE, NO)
*
xtreg lrgdppc ctax ctax_share19 lrgdppc_oecd, fe vce(cluster cnum)
 outreg2 using "tables/table6.doc" ,  word sortvar(ctax ctax_rate19 ctax_share19) ///
    addtext(Country FE, YES, Year FE, NO)
lincom ctax + .3*ctax_share19      /*  50th percentile   */
*
xtreg lrgdppc ctax ctax_share19 ydum*, fe vce(cluster cnum)
 outreg2 using "tables/table6.doc" ,  word sortvar(ctax ctax_rate19 ctax_share19) drop(ydum* o.ydum*) ///
    addtext(Country FE, YES, Year FE, YES)
lincom ctax + .3*ctax_share19      /*  50th percentile   */


log close






